#include <omp.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>

enum NAS_EP_B_c_16646 { false, true };
typedef enum NAS_EP_B_c_16646 logical;
struct named_NAS_EP_B_c_16660
{
	double real;
	double imag;
};

typedef struct named_NAS_EP_B_c_16660 dcomplex;
double randlc(double * x, double a);
void vranlc(int n, double * x, double a, double y[]);
void timer_clear(int n);
void timer_start(int n);
void timer_stop(int n);
double timer_read(int n);
void print_results(char * name, char class, int n1, int n2, int n3, int niter, double t, double mops, char * optype, logical verified, char * npbversion, char * compiletime, char * cs1, char * cs2, char * cs3, char * cs4, char * cs5, char * cs6, char * cs7);
static double x[(2*(1<<16))];
static double q[10];
void print_results(char * name, char class, int n1, int n2, int n3, int niter, double t, double mops, char * optype, logical verified, char * npbversion, char * compiletime, char * cs1, char * cs2, char * cs3, char * cs4, char * cs5, char * cs6, char * cs7)
{
	char size[16];
	int j;
	printf("\n\n %s Benchmark Completed.\n", name);
	printf(" Class           =             %12c\n", class);
	if ((n2==0)&&(n3==0))
	{
		if ((name[0]=='E')&&(name[1]=='P'))
		{
			sprintf(size, "%15.0lf", pow(2.0, n1));
			j=14;
			if (size[j]=='.')
			{
				size[j]=' ';
				j -- ;
			}
			size[j+1]='\0';
			printf(" Size            =          %15s\n", size);
		}
		else
		{
			printf(" Size            =             %12d\n", n1);
		}
	}
	else
	{
		printf(" Size            =           %4dx%4dx%4d\n", n1, n2, n3);
	}
	printf(" Iterations      =             %12d\n", niter);
	printf(" Time in seconds =             %12.2lf\n", t);
	printf(" Mop/s total     =          %15.2lf\n", mops);
	printf(" Operation type  = %24s\n", optype);
	if (verified)
	{
		printf(" Verification    =             %12s\n", "SUCCESSFUL");
	}
	else
	{
		printf(" Verification    =             %12s\n", "UNSUCCESSFUL");
	}
	printf(" Version         =             %12s\n", npbversion);
	printf(" Compile date    =             %12s\n", compiletime);
	printf("\n Compile options:\n""    CC           = %s\n", cs1);
	printf("    CLINK        = %s\n", cs2);
	printf("    C_LIB        = %s\n", cs3);
	printf("    C_INC        = %s\n", cs4);
	printf("    CFLAGS       = %s\n", cs5);
	printf("    CLINKFLAGS   = %s\n", cs6);
	printf("    RAND         = %s\n", cs7);
	printf("\n--------------------------------------\n"" Please send all errors/feedbacks to:\n"" Center for Manycore Programming\n"" cmp@aces.snu.ac.kr\n"" http://aces.snu.ac.kr\n""--------------------------------------\n\n");
	return ;
}

int main()
{
	omp_set_num_threads(4);
	double Mops, t1, t2, t3, t4, x1, x2;
	double sx, sy, tm, an, tt, gc;
	double sx_verify_value, sy_verify_value, sx_err, sy_err;
	int np;
	int i, ik, kk, l, k, nit;
	int k_offset, j;
	logical verified, timers_enabled;
double dum[3] = {1.0, 1.0, 1.0};
	char size[16];
	FILE * fp;
	int _ret_val_0;
	if ((fp=fopen("timer.flag", "r"))==((void * )0))
	{
		timers_enabled=false;
	}
	else
	{
		timers_enabled=true;
		fclose(fp);
	}
	sprintf(size, "%15.0lf", pow(2.0, 30+1));
	j=14;
	if (size[j]=='.')
	{
		j -- ;
	}
	size[j+1]='\0';
	printf("\n\n NAS Parallel Benchmarks (NPB3.3-SER-C) - EP Benchmark\n");
	printf("\n Number of random numbers generated: %15s\n", size);
	verified=false;
	np=(1<<(30-16));
	vranlc(0,  & dum[0], dum[1],  & dum[2]);
	dum[0]=randlc( & dum[1], dum[2]);
	#pragma cetus private(i)
	#pragma loop name main#0
	#pragma cetus parallel
	#pragma omp parallel for private(i)
	for (i=0; i<(2*(1<<16)); i ++ )
	{
		x[i]=( - 1.0E99);
	}
	Mops=log(sqrt(fabs(((1.0>1.0) ? 1.0 : 1.0))));
	timer_clear(0);
	timer_clear(1);
	timer_clear(2);
	timer_start(0);
	t1=1.220703125E9;
	vranlc(0,  & t1, 1.220703125E9, x);
	t1=1.220703125E9;
	#pragma cetus private(i, t2)
	#pragma loop name main#1
	for (i=0; i<(16+1); i ++ )
	{
		t2=randlc( & t1, t1);
	}
	an=t1;
	tt=2.71828183E8;
	gc=0.0;
	sx=0.0;
	sy=0.0;
	#pragma cetus private(i)
	#pragma loop name main#2
	#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(i)
	*/
	for (i=0; i<10; i ++ )
	{
		q[i]=0.0;
	}
	k_offset=( - 1);
	#pragma experimental section start null
	#pragma cetus private(i, ik, k, kk, l, t3, t4, x1, x2)
	#pragma loop name main#3
	/* #pragma cetus reduction(+: q[l], sx, sy)  */
	for (k=1; k<=np; k ++ )
	{
		kk=(k_offset+k);
		t1=2.71828183E8;
		t2=an;
		#pragma loop name main#3#0
		for (i=1; i<=100; i ++ )
		{
			ik=(kk/2);
			if ((2*ik)!=kk)
			{
				t3=randlc( & t1, t2);
			}
			if (ik==0)
			{
				break;
			}
			t3=randlc( & t2, t2);
			kk=ik;
		}
		if (timers_enabled)
		{
			timer_start(2);
		}
		vranlc(2*(1<<16),  & t1, 1.220703125E9, x);
		if (timers_enabled)
		{
			timer_stop(2);
		}
		if (timers_enabled)
		{
			timer_start(1);
		}
		#pragma cetus parallel
		#pragma cetus private(i, l, t1, t2, t3, t4, x1, x2)
		#pragma omp parallel private(i, l, t1, t2, t3, t4, x1, x2)
		{
			double reduce[10];
			//double * reduce = (double * )malloc(10*sizeof (double));
			int reduce_span_0;
			for (reduce_span_0=0; reduce_span_0<10; reduce_span_0 ++ )
			{
				reduce[reduce_span_0]=0;
			}
			#pragma loop name main#3#1
			#pragma cetus reduction(+: sx, sy)
			#pragma cetus for
			#pragma omp for reduction(+: sx, sy)
			for (i=0; i<(1<<16); i ++ )
			{
				x1=((2.0*x[2*i])-1.0);
				x2=((2.0*x[(2*i)+1])-1.0);
				t1=((x1*x1)+(x2*x2));
				if (t1<=1.0)
				{
					t2=sqrt((( - 2.0)*log(t1))/t1);
					t3=(x1*t2);
					t4=(x2*t2);
					l=((fabs(t3)>fabs(t4)) ? fabs(t3) : fabs(t4));
					reduce[l]=(reduce[l]+1.0);
					sx=(sx+t3);
					sy=(sy+t4);
				}
			}
			//#pragma cetus critical
			//#pragma omp critical
			//{
				for (reduce_span_0=0; reduce_span_0<10; reduce_span_0 ++ )
				{
					#pragma omp atomic
					q[reduce_span_0]+=reduce[reduce_span_0];
				}
			//}
		}
		if (timers_enabled)
		{
			timer_stop(1);
		}
	}
	#pragma experimental section stop null
	#pragma cetus private(i)
	#pragma loop name main#4
	#pragma cetus reduction(+: gc)
	#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(i) reduction(+: gc)
	*/
	for (i=0; i<10; i ++ )
	{
		gc=(gc+q[i]);
	}
	timer_stop(0);
	tm=timer_read(0);
	nit=0;
	verified=true;
	sx_verify_value=40338.15542441498;
	sy_verify_value=( - 26606.69192809235);
	if (verified)
	{
		sx_err=fabs((sx-sx_verify_value)/sx_verify_value);
		sy_err=fabs((sy-sy_verify_value)/sy_verify_value);
		verified=((sx_err<=1.0E-8)&&(sy_err<=1.0E-8));
	}
	Mops=((pow(2.0, 30+1)/tm)/1000000.0);
	printf("\nEP Benchmark Results:\n\n");
	printf("CPU Time =%10.4lf\n", tm);
	printf("N = 2^%5d\n", 30);
	printf("No. Gaussian Pairs = %15.0lf\n", gc);
	printf("Sums = %25.15lE %25.15lE\n", sx, sy);
	printf("Counts: \n");
	#pragma cetus private(i)
	#pragma loop name main#5
	for (i=0; i<10; i ++ )
	{
		printf("%3d%15.0lf\n", i, q[i]);
	}
	print_results("EP", 'B', 30+1, 0, 0, nit, tm, Mops, "Random numbers generated", verified, "3.3.1", "05 Nov 2022", "gcc", "$(CC)", "-lm", "-I../common", "-g -Wall -O3 -mcmodel=medium", "-O3 -mcmodel=medium", "randdp");
	if (timers_enabled)
	{
		if (tm<=0.0)
		{
			tm=1.0;
		}
		tt=timer_read(0);
		printf("\nTotal time:     %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
		tt=timer_read(1);
		printf("Gaussian pairs: %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
		tt=timer_read(2);
		printf("Random numbers: %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
	}
	_ret_val_0=0;
	return _ret_val_0;
}

double randlc(double * x, double a)
{
	const double r23 = 1.1920928955078125E-7;
	const double r46 = r23*r23;
	const double t23 = 8388608.0;
	const double t46 = t23*t23;
	double t1, t2, t3, t4, a1, a2, x1, x2, z;
	double r;
	t1=(r23*a);
	a1=((int)t1);
	a2=(a-(t23*a1));
	t1=(r23*( * x));
	x1=((int)t1);
	x2=(( * x)-(t23*x1));
	t1=((a1*x2)+(a2*x1));
	t2=((int)(r23*t1));
	z=(t1-(t23*t2));
	t3=((t23*z)+(a2*x2));
	t4=((int)(r46*t3));
	( * x)=(t3-(t46*t4));
	r=(r46*( * x));
	return r;
}

void vranlc(int n, double * x, double a, double y[])
{
	const double r23 = 1.1920928955078125E-7;
	const double r46 = r23*r23;
	const double t23 = 8388608.0;
	const double t46 = t23*t23;
	double t1, t2, t3, t4, a1, a2, x1, x2, z;
	int i;
	t1=(r23*a);
	a1=((int)t1);
	a2=(a-(t23*a1));
	#pragma cetus private(i, t1, t2, t3, t4, x1, x2, z)
	#pragma loop name vranlc#0
	for (i=0; i<n; i ++ )
	{
		t1=(r23*( * x));
		x1=((int)t1);
		x2=(( * x)-(t23*x1));
		t1=((a1*x2)+(a2*x1));
		t2=((int)(r23*t1));
		z=(t1-(t23*t2));
		t3=((t23*z)+(a2*x2));
		t4=((int)(r46*t3));
		( * x)=(t3-(t46*t4));
		y[i]=(r46*( * x));
	}
	return ;
}

static double elapsed_time(void )
{
	double t;
	wtime_( & t);
	return t;
}

static double start[64], elapsed[64];
void timer_clear(int n)
{
	elapsed[n]=0.0;
	return ;
}

void timer_start(int n)
{
	start[n]=elapsed_time();
	return ;
}

void timer_stop(int n)
{
	double t, now;
	now=elapsed_time();
	t=(now-start[n]);
	elapsed[n]+=t;
	return ;
}

double timer_read(int n)
{
	double _ret_val_0;
	_ret_val_0=elapsed[n];
	return _ret_val_0;
}

void wtime_(double * t)
{
	static int sec =  - 1;
	struct timeval tv;
	gettimeofday( & tv, (void * )0);
	if (sec<0)
	{
		sec=tv.tv_sec;
	}
	( * t)=((tv.tv_sec-sec)+(1.0E-6*tv.tv_usec));
	return ;
}
